<?php
// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit;

/**
 * Add Auto Classifieds Meta Boxes
 *
 * $id
 * $title
 * $callback
 * $post_type
 * $context
 * $priority
 * $callback_args 
 *
 * @since 0.1
 */

function add_pixad_auto_meta_boxes() {
	add_meta_box( 'pixad_auto_details', esc_html__( 'Auto Details', 'pixautodeal' ), 'pixad_auto_details', 'pixad-autos', 'normal', 'high' ); // Auto details metabox
	add_meta_box( 'pixad_auto_gallery', esc_html__( 'Gallery', 'pixautodeal' ), 'pixad_auto_gallery', 'pixad-autos', 'side', 'low' );
	add_meta_box( 'pixad_auto_feature', esc_html__( 'Auto Label', 'pixautodeal'), 'pixad_auto_feature', 'pixad-autos', 'side', 'low');
	add_meta_box( 'pixad_auto_sidebar', esc_html__( 'Auto Layout', 'pixautodeal'), 'pixad_auto_sidebar', 'pixad-autos', 'side', 'low');
	add_meta_box( 'pixad_auto_videos', esc_html__( 'Auto Video', 'pixautodeal' ), 'pixad_auto_videos', 'pixad-autos', 'side', 'low' );
	add_meta_box( 'pixad_auto_contacts', esc_html__( 'Contact Info', 'pixautodeal' ), 'pixad_auto_contacts', 'pixad-autos', 'normal', 'low' );
	add_meta_box( 'pixad_auto_custom_1', esc_html__( 'Custom Tab 1', 'pixautodeal' ), 'pixad_auto_custom_1', 'pixad-autos', 'normal', 'low' );
	add_meta_box( 'pixad_auto_custom_2', esc_html__( 'Custom Tab 2', 'pixautodeal' ), 'pixad_auto_custom_2', 'pixad-autos', 'normal', 'low' );
	add_meta_box( 'pixad_auto_custom_3', esc_html__( 'Custom Tab 3', 'pixautodeal' ), 'pixad_auto_custom_3', 'pixad-autos', 'normal', 'low' );
	add_meta_box( 'pixad_auto_banner_content', esc_html__( 'Banner', 'pixautodeal' ), 'pixad_auto_banner_content', 'pixad-autos', 'normal', 'low' );

}
// The function that outputs the metabox html
function pixad_auto_gallery() {
    global $post;
    // Here we get the current images ids of the gallery
    $values = get_post_custom($post->ID);

    if(isset($values['pixad_auto_gallery'])) {
        // The json decode and base64 decode return an array of image ids
        $ids = json_decode(base64_decode($values['pixad_auto_gallery'][0]));
    }
    else {
        $ids = array();
    }
    wp_nonce_field('pixad_meta_box_nonce', 'meta_box_nonce'); // Security
    // Implode the array to a comma separated list
    $cs_ids = is_array($ids) ? implode(",", $ids) : '';
    // We display the gallery
    $html  = do_shortcode('[gallery ids="'.$cs_ids.'"]');
    // Here we store the image ids which are used when saving the auto
    $html .= '<input id="pixad_auto_gallery_ids" type="hidden" name="pixad_auto_gallery_ids" value="'.$cs_ids. '" />';
    // A button which we will bind to later on in JavaScript
    $html .= '<input id="manage_gallery" title="Manage gallery" type="button" value="Manage gallery" />';
    $html .= '<input id="clear_gallery" title="Clear gallery" type="button" value="Clear gallery" />';
    echo $html;
}

// The function that outputs the metabox html
function pixad_auto_feature() {

    $sel_l = get_post_meta( get_the_ID(), 'pixad_auto_featured', true );
	?>
		<select class="rwmb-select" name="pixad_auto_featured" />
			<option value="" <?php selected( $sel_l, '', true ); ?> ><?php esc_html_e( 'Without Label', 'pixautodeal') ?></option>
    	    <option value="Featured" <?php selected( $sel_l, 'Featured', true ); ?> ><?php esc_html_e( 'Featured', 'pixautodeal') ?></option>
            <option value="Sold" <?php selected( $sel_l, 'Sold', true ); ?> ><?php esc_html_e( 'Sold', 'pixautodeal') ?></option>
            <option value="Reserved" <?php selected( $sel_l, 'Reserved', true ); ?> ><?php esc_html_e( 'Reserved', 'pixautodeal') ?></option>
        </select>
	<?php
}

// The function that outputs the metabox html
function pixad_auto_sidebar() {
    global $post;

    $sel_l = get_post_meta( get_the_ID(), 'pixad_auto_sidebar_layout', true );
	?>
	    <p><strong><?php echo esc_html__('Sidebar Position', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_sidebar_layout" />
    	    <option value="" <?php selected( $sel_l, '', true ); ?> ><?php esc_html_e( 'Right', 'pixautodeal') ?></option>
            <option value="left" <?php selected( $sel_l, 'left', true ); ?> ><?php esc_html_e( 'Left', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_s = get_post_meta( get_the_ID(), 'pixad_auto_specifications', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_specifications', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Specifications', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_specifications" />
    	    <option value="1" <?php selected( $sel_s, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_s, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_r = get_post_meta( get_the_ID(), 'pixad_auto_related', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_related', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Related Cars', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_related" />
    	    <option value="1" <?php selected( $sel_r, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_r, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_sh = get_post_meta( get_the_ID(), 'pixad_auto_share', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_share', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Share This', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_share" />
    	    <option value="1" <?php selected( $sel_sh, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_sh, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_d = get_post_meta( get_the_ID(), 'pixad_auto_description_tab', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_description_tab', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Vehicle Description Tab', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_description_tab" />
    	    <option value="1" <?php selected( $sel_d, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_d, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_f = get_post_meta( get_the_ID(), 'pixad_auto_features_tab', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_features_tab', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Features Tab', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_features_tab" />
    	    <option value="1" <?php selected( $sel_f, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_f, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php

	$sel_c = get_post_meta( get_the_ID(), 'pixad_auto_contacts_tab', true ) != '' ? get_post_meta( get_the_ID(), 'pixad_auto_contacts_tab', true ) : 1;
	?>
	    <p><strong><?php echo esc_html__('Contacts Tab', 'pixautodeal')?></strong></p>
		<select class="rwmb-select" name="pixad_auto_contacts_tab" />
    	    <option value="1" <?php selected( $sel_c, '1', true ); ?> ><?php esc_html_e( 'Show', 'pixautodeal') ?></option>
            <option value="0" <?php selected( $sel_c, '0', true ); ?> ><?php esc_html_e( 'Hide', 'pixautodeal') ?></option>
        </select>
	<?php
}


function pixad_auto_videos() {
	global $post;
	?>
	<div id="auto_video_container">
		<?php _e('Upload your Video in 3 formats: MP4, OGG and WEBM', 'pixautodeal') ?>
		<ul class="auto_video">
			<?php
				
				$auto_video_code = get_post_meta( $post->ID, '_auto_video_code', true );


				if ( metadata_exists( 'post', $post->ID, '_auto_video_gallery' ) ) {
					$auto_image_gallery = get_post_meta( $post->ID, '_auto_video_gallery', true );
				} 
				
				$video_attachments = false;
				
				if(isset($auto_image_gallery) && $auto_image_gallery != '') {
					$video_attachments = get_posts( array(
						'post_type' => 'attachment',
						'include' => $auto_image_gallery
					) ); 
				}
				
				
				
				//$attachments = array_filter( explode( ',', $auto_image_gallery ) );

				if ( $video_attachments )
					foreach ( $video_attachments as $attachment ) {
						echo '<li class="video" data-attachment_id="' . $attachment->id . '">
							Format: ' . $attachment->post_mime_type . '
							<ul class="actions">
								<li><a href="#" class="delete" title="' . __( 'Delete image', 'pixautodeal' ) . '">' . __( 'Delete', 'pixautodeal' ) . '</a></li>
							</ul>
						</li>';
					}
			?>
		</ul>

		<input type="hidden" id="auto_video_gallery" name="auto_video_gallery" value="<?php echo esc_attr( $auto_image_gallery ); ?>" />

	</div>
	<p class="add_auto_video hide-if-no-js">
		<a href="#"><?php _e( 'Add auto gallery video', 'pixautodeal' ); ?></a>
	</p>
	<p>
		<?php _e('Or you can use YouTube or Vimeo iframe code', 'pixautodeal'); ?>
	</p>
	<div class="auto_iframe_video">
		
		<textarea name="auto_video_code" id="auto_video_code" rows="7"><?php echo esc_attr( $auto_video_code ); ?></textarea>
		
	</div>
	<script type="text/javascript">
		jQuery(document).ready(function($){

			// Uploading files
			var auto_gallery_frame;
			var $image_gallery_ids = $('#auto_video_gallery');
			var $auto_images = $('#auto_video_container ul.auto_video');

			jQuery('.add_auto_video').on( 'click', 'a', function( event ) {

				var $el = $(this);
				var attachment_ids = $image_gallery_ids.val();

				event.preventDefault();

				// If the media frame already exists, reopen it.
				if ( auto_gallery_frame ) {
					auto_gallery_frame.open();
					return;
				}

				// Create the media frame.
				auto_gallery_frame = wp.media.frames.downloadable_file = wp.media({
					// Set the title of the modal.
					title: '<?php _e( 'Add Images to Product Gallery', 'pixautodeal' ); ?>',
					button: {
						text: '<?php _e( 'Add to gallery', 'pixautodeal' ); ?>',
					},
					multiple: true,
					library : { type : 'video'}
				});

				// When an image is selected, run a callback.
				auto_gallery_frame.on( 'select', function() {

					var selection = auto_gallery_frame.state().get('selection');

					selection.map( function( attachment ) {

						attachment = attachment.toJSON();

						if ( attachment.id ) {
							attachment_ids = attachment_ids ? attachment_ids + "," + attachment.id : attachment.id;

							$auto_images.append('\
								<li class="video" data-attachment_id="' + attachment.id + '">\
									Video\
									<ul class="actions">\
										<li><a href="#" class="delete" title="<?php _e( 'Delete video', 'pixautodeal' ); ?>"><?php _e( 'Delete', 'pixautodeal' ); ?></a></li>\
									</ul>\
								</li>');
						}

					} );

					$image_gallery_ids.val( attachment_ids );
				});

				// Finally, open the modal.
				auto_gallery_frame.open();
			});

			// Image ordering
			$auto_images.sortable({
				items: 'li.video',
				cursor: 'move',
				scrollSensitivity:40,
				forcePlaceholderSize: true,
				forceHelperSize: false,
				helper: 'clone',
				opacity: 0.65,
				placeholder: 'wc-metabox-sortable-placeholder',
				start:function(event,ui){
					ui.item.css('background-color','#f6f6f6');
				},
				stop:function(event,ui){
					ui.item.removeAttr('style');
				},
				update: function(event, ui) {
					var attachment_ids = '';

					$('#auto_video_container ul li.video').css('cursor','default').each(function() {
						var attachment_id = jQuery(this).attr( 'data-attachment_id' );
						attachment_ids = attachment_ids + attachment_id + ',';
					});

					$image_gallery_ids.val( attachment_ids );
				}
			});

			// Remove images
			$('#auto_video_container').on( 'click', 'a.delete', function() {

				$(this).closest('li.video').remove();

				var attachment_ids = '';

				$('#auto_video_container ul li.video').css('cursor','default').each(function() {
					var attachment_id = jQuery(this).attr( 'data-attachment_id' );
					attachment_ids = attachment_ids + attachment_id + ',';
				});

				$image_gallery_ids.val( attachment_ids );

				return false;
			} );

		});
	</script>
	<?php
}


function pixad_auto_contacts( $post ){
    //so, dont ned to use esc_attr in front of get_post_meta
    $value =  get_post_meta($_GET['post'], 'pixad_auto_contact' , true ) ;
    wp_editor( $value, 'pixad_auto_contacts_editor', $settings = array('textarea_name'=>'pixad_auto_contact_info', 'editor_height'=>100) );
}

function pixad_auto_custom_1( $post ){

    $custom_title_1 = get_post_meta( $post->ID, 'pixad_auto_custom_title_1', true );
    ?>
    <div class="pixad-panel">
		<div class="pixad-panel-body">
			<div class="pixad-form-horizontal">
			    <div class="">
				    <label class="col-lg-1 pixad-control-label">
						<?php _e( 'Tab Title', 'pixautodeal' ); ?>
					</label>
					<div class="col-lg-10">
						<input name="pixad_auto_custom_title_1" type="text" value="<?php echo esc_attr($custom_title_1); ?>" class="pixad-form-control">
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php

    $value =  get_post_meta($post->ID, 'pixad_auto_custom_content_1' , true ) ;
    wp_editor( $value, 'pixad_auto_custom_editor_1', $settings = array('textarea_name'=>'pixad_auto_custom_info_1', 'editor_height'=>150) );

}

function pixad_auto_custom_2( $post ){

    $custom_title_2 = get_post_meta( $post->ID, 'pixad_auto_custom_title_2', true );
    ?>
    <div class="pixad-panel">
		<div class="pixad-panel-body">
			<div class="pixad-form-horizontal">
			    <div class="">
				    <label class="col-lg-1 pixad-control-label">
						<?php _e( 'Tab Title', 'pixautodeal' ); ?>
					</label>
					<div class="col-lg-10">
						<input name="pixad_auto_custom_title_2" type="text" value="<?php echo esc_attr($custom_title_2); ?>" class="pixad-form-control">
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php

    $value =  get_post_meta($post->ID, 'pixad_auto_custom_content_2' , true ) ;
    wp_editor( $value, 'pixad_auto_custom_editor_2', $settings = array('textarea_name'=>'pixad_auto_custom_info_2', 'editor_height'=>150) );

}

function pixad_auto_custom_3( $post ){

    $custom_title_3 = get_post_meta( $post->ID, 'pixad_auto_custom_title_3', true );
    ?>
    <div class="pixad-panel">
		<div class="pixad-panel-body">
			<div class="pixad-form-horizontal">
			    <div class="">
				    <label class="col-lg-1 pixad-control-label">
						<?php _e( 'Tab Title', 'pixautodeal' ); ?>
					</label>
					<div class="col-lg-10">
						<input name="pixad_auto_custom_title_3" type="text" value="<?php echo esc_attr($custom_title_3); ?>" class="pixad-form-control">
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php

    $value =  get_post_meta($post->ID, 'pixad_auto_custom_content_3' , true ) ;
    wp_editor( $value, 'pixad_auto_custom_editor_3', $settings = array('textarea_name'=>'pixad_auto_custom_info_3', 'editor_height'=>150) );

}

function pixad_auto_banner_content( $post ){
    //so, dont ned to use esc_attr in front of get_post_meta
    $value =  get_post_meta($post->ID, 'pixad_auto_banner' , true ) ;
    wp_editor( $value, 'pixad_auto_banner_editor', $settings = array('textarea_name'=>'pixad_auto_banner_info', 'editor_height'=>150) );
    $link = get_post_meta( $post->ID, 'pixad_auto_banner_link', true );
    ?>

    <div class="pixad-panel">
		<div class="pixad-panel-body">
			<div class="pixad-form-horizontal">
			    <div class="">
				    <label class="col-lg-1 pixad-control-label">
						<?php _e( 'Banner Link', 'pixautodeal' ); ?>
					</label>
					<div class="col-lg-10">
						<input name="pixad_auto_banner_link" type="text" value="<?php echo esc_url($link); ?>" class="pixad-form-control">
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}


/**
 * Get Meta Value
 *
 * @since 0.1
 */
function pixad_get_meta( $key ) {
	return sanitize_text_field( get_post_meta( get_the_ID(), $key, true ) );
}
/**
 * Auto Details MetaBox
 *
 * @since 0.1
 */
function pixad_auto_details() {
	global $post;
	$Settings = new PIXAD_Settings();
	$validate = $Settings->getSettings( 'WP_OPTIONS', '_pixad_autos_validation', true ); // Get validation settings
	$validate = pixad::validation( $validate );
	$currencies = unserialize( get_option( '_pixad_autos_currencies' ) ); ?>
	
<input name="pixad_autos-meta" type="hidden" value="save">

<div class="pixad-panel">
	<div class="pixad-panel-body">
		<div class="pixad-form-horizontal">

			<?php if( $validate['auto-version_show'] || $validate['auto-version_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Auto Version', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-version" type="text" placeholder="eg: 1.6 hdi" value="<?php echo pixad_get_meta( '_auto_version' ); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-year_show'] || $validate['auto-year_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Made Year', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
				    <input name="auto-year" type="number" min="1930" max="<?php echo (date('Y')+1) ?>" placeholder="eg: 2017" value="<?php echo pixad_get_meta('_auto_year'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-transmission_show'] || $validate['auto-transmission_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Transmission', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-transmission" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<option value="automatic" <?php if(pixad_get_meta('_auto_transmission')=='automatic') echo 'selected'; ?>><?php _e( 'Automatic', 'pixautodeal' ); ?></option>
						<option value="manual" <?php if(pixad_get_meta('_auto_transmission')=='manual') echo 'selected'; ?>><?php _e( 'Manual', 'pixautodeal' ); ?></option>
						<option value="semi-automatic" <?php if(pixad_get_meta('_auto_transmission')=='semi-automatic') echo 'selected'; ?>><?php _e( 'Semi-Automatic', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-doors_show'] || $validate['auto-doors_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Doors', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-doors" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<?php pixad_get_options_range( 2, 5, pixad_get_meta('_auto_doors') ); ?>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-fuel_show'] || $validate['auto-fuel_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Fuel Type', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-fuel" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<option value="diesel" <?php if(pixad_get_meta('_auto_fuel')=='diesel') echo 'selected'; ?>><?php _e( 'Diesel', 'pixautodeal' ); ?></option>
						<option value="electric" <?php if(pixad_get_meta('_auto_fuel')=='electric') echo 'selected'; ?>><?php _e( 'Electric', 'pixautodeal' ); ?></option>
						<option value="petrol" <?php selected( 'petrol', pixad_get_meta('_auto_fuel'), true ); ?>><?php _e( 'Petrol', 'pixautodeal' ); ?></option>
						<option value="hybrid" <?php if(pixad_get_meta('_auto_fuel')=='hybrid') echo 'selected'; ?>><?php _e( 'Hybrid', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-condition_show'] || $validate['auto-condition_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Auto Condition', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-condition" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<option value="new" <?php if(pixad_get_meta('_auto_condition')=='new') echo 'selected'; ?>><?php _e( 'New', 'pixautodeal' ); ?></option>
						<option value="used" <?php if(pixad_get_meta('_auto_condition')=='used') echo 'selected'; ?>><?php _e( 'Used', 'pixautodeal' ); ?></option>
						<option value="driver" <?php if(pixad_get_meta('_auto_condition')=='driver') echo 'selected'; ?>><?php _e( 'Driver', 'pixautodeal' ); ?></option>
						<option value="non driver" <?php if(pixad_get_meta('_auto_condition')=='non driver') echo 'selected'; ?>><?php _e( 'Non driver', 'pixautodeal' ); ?></option>
						<option value="projectcar" <?php if(pixad_get_meta('_auto_condition')=='projectcar') echo 'selected'; ?>><?php _e( 'Projectcar', 'pixautodeal' ); ?></option>
						<option value="barnfind" <?php if(pixad_get_meta('_auto_condition')=='barnfind') echo 'selected'; ?>><?php _e( 'Barnfind', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['auto-purpose_show'] || $validate['auto-purpose_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Auto Purpose', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-purpose" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<option value="rent" <?php if(pixad_get_meta('_auto_purpose')=='rent') echo 'selected'; ?>><?php _e( 'Rent', 'pixautodeal' ); ?></option>
						<option value="experience" <?php if(pixad_get_meta('_auto_purpose')=='experience') echo 'selected'; ?>><?php _e( 'Experience', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>
			
			<?php if( $validate['auto-drive_show'] || $validate['auto-drive_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Auto Drive', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-drive" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<option value="front" <?php if(pixad_get_meta('_auto_drive')=='front') echo 'selected'; ?>><?php _e( 'Front', 'pixautodeal' ); ?></option>
						<option value="rear" <?php if(pixad_get_meta('_auto_drive')=='rear') echo 'selected'; ?>><?php _e( 'Rear', 'pixautodeal' ); ?></option>
						<option value="4x4" <?php if(pixad_get_meta('_auto_drive')=='4x4') echo 'selected'; ?>><?php _e( '4x4', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-color_show'] || $validate['auto-color_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Color', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-color" type="text" placeholder="eg: red" value="<?php echo pixad_get_meta('_auto_color'); ?>" list="color_option" class="pixad-form-control">
					<datalist id="color_option">
                        <option value="white"><?php esc_attr_e( 'white', 'pixautodeal' ); ?></option>
                        <option value="silver"><?php esc_attr_e( 'silver', 'pixautodeal' ); ?></option>
                        <option value="black"><?php esc_attr_e( 'black', 'pixautodeal' ); ?></option>
                        <option value="grey"><?php esc_attr_e( 'grey', 'pixautodeal' ); ?></option>
                        <option value="blue"><?php esc_attr_e( 'blue', 'pixautodeal' ); ?></option>
                        <option value="red"><?php esc_attr_e( 'red', 'pixautodeal' ); ?></option>
                        <option value="brown"><?php esc_attr_e( 'brown', 'pixautodeal' ); ?></option>
                        <option value="green"><?php esc_attr_e( 'green', 'pixautodeal' ); ?></option>
                        <option value="yellow"><?php esc_attr_e( 'yellow', 'pixautodeal' ); ?></option>
                        <option value="orange"><?php esc_attr_e( 'orange', 'pixautodeal' ); ?></option>
                        <option value="purple"><?php esc_attr_e( 'purple', 'pixautodeal' ); ?></option>
					</datalist>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-color-int_show'] || $validate['auto-color-int_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Interior Color', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-color-int" type="text" placeholder="eg: black" value="<?php echo pixad_get_meta('_auto_color_int'); ?>" list="color_int_option" class="pixad-form-control">
					<datalist id="color_int_option">
					    <option value="white"><?php esc_attr_e( 'white', 'pixautodeal' ); ?></option>
                        <option value="silver"><?php esc_attr_e( 'silver', 'pixautodeal' ); ?></option>
                        <option value="black"><?php esc_attr_e( 'black', 'pixautodeal' ); ?></option>
                        <option value="grey"><?php esc_attr_e( 'grey', 'pixautodeal' ); ?></option>
                        <option value="blue"><?php esc_attr_e( 'blue', 'pixautodeal' ); ?></option>
                        <option value="red"><?php esc_attr_e( 'red', 'pixautodeal' ); ?></option>
                        <option value="brown"><?php esc_attr_e( 'brown', 'pixautodeal' ); ?></option>
                        <option value="beige"><?php esc_attr_e( 'beige', 'pixautodeal' ); ?></option>
					</datalist>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-price_show'] || $validate['auto-price_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Price', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-price" type="text" placeholder="eg: 10000" value="<?php echo pixad_get_meta('_auto_price'); ?>" list="price_option" class="pixad-form-control">
					<datalist id="price_option">
					  <option value="Request"><?php esc_attr_e( 'Request', 'pixautodeal' ); ?></option>
					  <option value="Reserved"><?php esc_attr_e( 'Reserved', 'pixautodeal' ); ?></option>
					</datalist>
					<span class="errprice"></span>
				</div>
			</div>
            <?php endif; ?>

            <?php if( $validate['auto-sale-price_show'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Sale Price', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-sale-price" type="text" placeholder="eg: 9000" value="<?php echo pixad_get_meta('_auto_sale_price'); ?>" class="pixad-form-control">
					<span class="errprice"></span>
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['auto-stock-status_show'] || $validate['auto-stock-status_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Stock status', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-stock-status" class="pixad-form-control">
						<option value="in stock" <?php selected( 'in stock', pixad_get_meta('_auto_stock_status'), true ); ?>><?php _e( 'In stock', 'pixautodeal' ); ?></option>
						<option value="expected" <?php selected( 'expected', pixad_get_meta('_auto_stock_status'), true ); ?>><?php _e( 'Expected', 'pixautodeal' ); ?></option>
						<option value="out of stock" <?php selected( 'out of stock', pixad_get_meta('_auto_stock_status'), true ); ?>><?php _e( 'Out of stock', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['auto-price-type_show'] || $validate['auto-price-type_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Price Type', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-price-type" class="pixad-form-control">
						<option value="fixed" <?php selected( 'fixed', pixad_get_meta('_auto_price_type'), true ); ?>><?php _e( 'Fixed', 'pixautodeal' ); ?></option>
						<option value="negotiable" <?php selected( 'negotiable', pixad_get_meta('_auto_price_type'), true ); ?>><?php _e( 'Negotiable', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-warranty_show'] || $validate['auto-warranty_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Warranty', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="auto-warranty" class="pixad-form-control">
						<option value="no" <?php selected( 'no', pixad_get_meta('_auto_warranty'), true ); ?>><?php _e( 'No', 'pixautodeal' ); ?></option>
						<option value="yes" <?php selected( 'yes', pixad_get_meta('_auto_warranty'), true ); ?>><?php _e( 'Yes', 'pixautodeal' ); ?></option>
					</select>
				</div>
			</div>
			<?php endif; ?>

<?php /* ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Currency', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="currency" class="pixad-form-control">
					<?php if( $currencies ): foreach( $currencies as $currency ): ?>

						<option value="<?php echo $currency['iso']; ?>" <?php selected( pixad_get_meta('_auto_currency'), $currency['iso'], true ); ?>><?php echo $currency['iso']; ?></option>

					<?php endforeach; else: ?>

						<option value="EUR" <?php selected( pixad_get_meta('_auto_currency'), 'EUR', true ); ?>><?php echo 'EUR'; ?></option>
						<option value="USD" <?php selected( pixad_get_meta('_auto_currency'), 'USD', true ); ?>><?php echo 'USD'; ?></option>

					<?php endif; ?>
					</select>
				</div>
			</div>
<?php */ ?>
            <?php if( $validate['auto-mileage_show'] || $validate['auto-mileage_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Mileage', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-mileage" type="text" placeholder="eg: 100000" value="<?php echo pixad_get_meta('_auto_mileage'); ?>" class="pixad-form-control">
					<span class="errmileage"></span>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-vin_show'] || $validate['auto-vin_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'VIN', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-vin" type="text" placeholder="eg: 1VXBR12EXCP901213" value="<?php echo pixad_get_meta('_auto_vin'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-engine_show'] || $validate['auto-engine_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Engine, cm3', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-engine" type="text" placeholder="eg: 1900" value="<?php echo pixad_get_meta('_auto_engine'); ?>" class="pixad-form-control">
					<span class="errengine"></span>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-horsepower_show'] || $validate['auto-horsepower_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Horsepower, hp', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-horsepower" type="text" placeholder="eg: 200" value="<?php echo pixad_get_meta('_auto_horsepower'); ?>" class="pixad-form-control">
					<span class="errhorsepower"></span>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['auto-seats_show'] || $validate['auto-seats_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seating Capacity', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="auto-seats" type="text" placeholder="eg: 5" value="<?php echo pixad_get_meta('_auto_seats'); ?>" class="pixad-form-control">
					<span class="errseats"></span>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['first-name_show'] || $validate['first-name_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller first name', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-first-name" type="text" placeholder="eg: John" value="<?php echo pixad_get_meta('_first_name'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['last-name_show'] || $validate['last-name_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller last name', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-last-name" type="text" placeholder="eg: Doe" value="<?php echo pixad_get_meta('_seller_last_name'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-email_show'] || $validate['seller-email_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller email', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-email" type="text" placeholder="eg: johndoe@gmail.com" value="<?php echo pixad_get_meta('_seller_email'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-phone_show'] || $validate['seller-phone_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller phone', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-phone" type="text" placeholder="eg: +38160656545" value="<?php echo pixad_get_meta('_seller_phone'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-company_show'] || $validate['seller-company_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller company', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-company" type="text" placeholder="eg: General Motors" value="<?php echo pixad_get_meta('_seller_company'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-country_show'] || $validate['seller-country_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller country', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<select name="seller-country" class="pixad-form-control">
						<option value=""><?php _e( '-- Please Select --', 'pixautodeal' ); ?></option>
						<?php $country = new PIXAD_Country(); $country->option_output( pixad_get_meta('_seller_country') ); ?>
					</select>
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-state_show'] || $validate['seller-state_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller state', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-state" type="text" placeholder="eg: Texas" value="<?php echo pixad_get_meta('_seller_state'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

			<?php if( $validate['seller-town_show'] || $validate['seller-town_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller town', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-town" type="text" placeholder="eg: Atlanta" value="<?php echo pixad_get_meta('_seller_town'); ?>" class="pixad-form-control">
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['seller-location_show'] || $validate['seller-location_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller location label', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-location" type="text" placeholder="eg: 1410 W Cheltenham Ave, Philadelphia, PA 19126, United States" value="<?php echo pixad_get_meta('_seller_location'); ?>" class="pixad-form-control">
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['seller-location-lat_show'] || $validate['seller-location-lat_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller location latitude', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-location-lat" type="text" placeholder="eg: 40.0632723" value="<?php echo pixad_get_meta('_seller_location_lat'); ?>" class="pixad-form-control">
				</div>
			</div>
            <?php endif; ?>

			<?php if( $validate['seller-location-long_show'] || $validate['seller-location-long_req'] ): ?>
			<div class="pixad-form-group">
				<label class="col-lg-2 pixad-control-label">
					<?php _e( 'Seller location longitude', 'pixautodeal' ); ?>
				</label>
				<div class="col-lg-9">
					<input name="seller-location-long" type="text" placeholder="eg: -75.1411223" value="<?php echo pixad_get_meta('_seller_location_long'); ?>" class="pixad-form-control">
				</div>
			</div>
			<?php endif; ?>

		</div>
	</div>
</div>
<?php } // End auto details

/**
 * Save Custom MetaBox fields
 *
 * @since 0.1
 * @return boolean
 */
function save_pixad_autos_meta_boxes( $post_id ) {
	
	// Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
	
	if( isset( $_POST['pixad_autos-meta'] ) && $_POST['pixad_autos-meta'] == 'save' ) {
		$term_name = '';

		if(isset($_POST['tax_input']['auto-model'][1])){
			$term = get_term( $_POST['tax_input']['auto-model'][1] );
			$term_name = $term->name;
		}

		$options = array(
			'_auto_make'			=> sanitize_text_field( $term_name ),
			'_auto_version'			=> sanitize_text_field( $_POST['auto-version'] ),
			'_auto_year'			=> sanitize_text_field( $_POST['auto-year'] ),
			'_auto_transmission'	=> sanitize_text_field( $_POST['auto-transmission'] ),
			'_auto_doors'			=> sanitize_text_field( $_POST['auto-doors'] ),
			'_auto_fuel'			=> sanitize_text_field( $_POST['auto-fuel'] ),
			'_auto_condition'		=> sanitize_text_field( $_POST['auto-condition'] ),
			'_auto_purpose'		    => sanitize_text_field( $_POST['auto-purpose'] ),
			'_auto_drive'			=> sanitize_text_field( $_POST['auto-drive'] ),
			'_auto_color'			=> sanitize_text_field( $_POST['auto-color'] ),
			'_auto_color_int'		=> sanitize_text_field( $_POST['auto-color-int'] ),
			'_auto_price'			=> sanitize_text_field( $_POST['auto-price'] ),
			'_auto_sale_price'		=> sanitize_text_field( $_POST['auto-sale-price'] ),
			'_auto_stock_status'	=> sanitize_text_field( $_POST['auto-stock-status'] ),
			'_auto_price_type'		=> sanitize_text_field( $_POST['auto-price-type'] ),
			'_auto_warranty'		=> sanitize_text_field( $_POST['auto-warranty'] ),
			//'_auto_currency'		=> sanitize_text_field( $_POST['currency'] ),
			'_auto_mileage'			=> sanitize_text_field( $_POST['auto-mileage'] ),
			'_auto_vin'				=> sanitize_text_field( $_POST['auto-vin'] ),
			'_auto_engine'			=> sanitize_text_field( $_POST['auto-engine'] ),
			'_auto_horsepower'		=> sanitize_text_field( $_POST['auto-horsepower'] ),
			'_auto_seats'			=> sanitize_text_field( $_POST['auto-seats'] ),
			'_auto_images'			=> sanitize_text_field( $_POST['auto-images'] ),
			'_seller_first_name'	=> sanitize_text_field( $_POST['seller-first-name'] ),
			'_seller_last_name'		=> sanitize_text_field( $_POST['seller-last-name'] ),
			'_seller_email'			=> sanitize_text_field( $_POST['seller-email'] ),
			'_seller_phone'			=> sanitize_text_field( $_POST['seller-phone'] ),
			'_seller_company'		=> sanitize_text_field( $_POST['seller-company'] ),
			'_seller_country'		=> sanitize_text_field( $_POST['seller-country'] ),
			'_seller_state'			=> sanitize_text_field( $_POST['seller-state'] ),
			'_seller_town'			=> sanitize_text_field( $_POST['seller-town'] ),
			'_seller_location'	    => sanitize_text_field( $_POST['seller-location'] ),
			'_seller_location_lat'	=> sanitize_text_field( $_POST['seller-location-lat'] ),
			'_seller_location_long'	=> sanitize_text_field( $_POST['seller-location-long'] ),
		);

		foreach( $options as $key => $value ) {
			update_post_meta( $post_id, $key, $value );
		}

	}

	if (isset($_POST['pixad_auto_gallery_ids']) && $_POST['pixad_auto_gallery_ids'] != '') {
        // Encode so it can be stored an retrieved properly
        $encode = base64_encode(json_encode(explode(',',$_POST['pixad_auto_gallery_ids'])));
        update_post_meta($post_id, 'pixad_auto_gallery', $encode);
    }

	if (isset($_POST['pixad_auto_featured'])) {
        update_post_meta($post_id, 'pixad_auto_featured', $_POST['pixad_auto_featured']);
        if($_POST['pixad_auto_featured'] == 'Sold'){
            update_post_meta($post_id, 'pixad_auto_sold', '1');
        } else {
            delete_post_meta($post_id, 'pixad_auto_sold');
        }
    }
    else
        delete_post_meta($post_id, 'pixad_auto_featured');

    if (isset($_POST['pixad_auto_sidebar_layout'])) {
        update_post_meta($post_id, 'pixad_auto_sidebar_layout', $_POST['pixad_auto_sidebar_layout']);
    }
    if (isset($_POST['pixad_auto_specifications'])) {
        update_post_meta($post_id, 'pixad_auto_specifications', $_POST['pixad_auto_specifications']);
    }
    if (isset($_POST['pixad_auto_related'])) {
        update_post_meta($post_id, 'pixad_auto_related', $_POST['pixad_auto_related']);
    }
    if (isset($_POST['pixad_auto_share'])) {
        update_post_meta($post_id, 'pixad_auto_share', $_POST['pixad_auto_share']);
    }
    if (isset($_POST['pixad_auto_description_tab'])) {
        update_post_meta($post_id, 'pixad_auto_description_tab', $_POST['pixad_auto_description_tab']);
    }
    if (isset($_POST['pixad_auto_features_tab'])) {
        update_post_meta($post_id, 'pixad_auto_features_tab', $_POST['pixad_auto_features_tab']);
    }
    if (isset($_POST['pixad_auto_contacts_tab'])) {
        update_post_meta($post_id, 'pixad_auto_contacts_tab', $_POST['pixad_auto_contacts_tab']);
    }

    if (isset($_POST['auto_video_gallery'])) {
		$video_ids =  explode( ',',  $_POST['auto_video_gallery']  ) ;
		update_post_meta( $post_id, '_auto_video_gallery', implode( ',', $video_ids ) );
		update_post_meta( $post_id, '_auto_video_code',  $_POST['auto_video_code']  );
	}

	if (isset($_POST['pixad_auto_contact_info'])){
        $data = $_POST['pixad_auto_contact_info'];
        update_post_meta($post_id, 'pixad_auto_contact', $data );
    }

	if (isset($_POST['pixad_auto_custom_title_1'])){
        update_post_meta($post_id, 'pixad_auto_custom_title_1', $_POST['pixad_auto_custom_title_1'] );
    } else {
        delete_post_meta($post_id, 'pixad_auto_custom_title_1');
    }
	if (isset($_POST['pixad_auto_custom_info_1'])){
        $data = $_POST['pixad_auto_custom_info_1'];
        update_post_meta($post_id, 'pixad_auto_custom_content_1', $data );
    }

    if (isset($_POST['pixad_auto_custom_title_2'])){
        update_post_meta($post_id, 'pixad_auto_custom_title_2', $_POST['pixad_auto_custom_title_2'] );
    } else {
        delete_post_meta($post_id, 'pixad_auto_custom_title_2');
    }
	if (isset($_POST['pixad_auto_custom_info_2'])){
        $data = $_POST['pixad_auto_custom_info_2'];
        update_post_meta($post_id, 'pixad_auto_custom_content_2', $data );
    }

    if (isset($_POST['pixad_auto_custom_title_3'])){
        update_post_meta($post_id, 'pixad_auto_custom_title_3', $_POST['pixad_auto_custom_title_3'] );
    } else {
        delete_post_meta($post_id, 'pixad_auto_custom_title_3');
    }
	if (isset($_POST['pixad_auto_custom_info_3'])){
        $data = $_POST['pixad_auto_custom_info_3'];
        update_post_meta($post_id, 'pixad_auto_custom_content_3', $data );
    }

    if (isset($_POST['pixad_auto_banner_info'])){
        $data = $_POST['pixad_auto_banner_info'];
        update_post_meta($post_id, 'pixad_auto_banner', $data );
    }

    if (isset($_POST['pixad_auto_banner_link'])){
        update_post_meta($post_id, 'pixad_auto_banner_link', $_POST['pixad_auto_banner_link'] );
    } else {
        delete_post_meta($post_id, 'pixad_auto_banner_link');
    }


}
add_action( 'save_post', 'save_pixad_autos_meta_boxes' );


function pixad_get_external_video($post_id) {
	if(!$post_id) return false;
	$auto_video_code = str_replace('https://', 'http://', get_post_meta( $post_id, '_auto_video_code', true ));

	return $auto_video_code;
}

function pixad_get_external_video_img($post_id) {
	if(!$post_id) return false;
	$auto_video_code = get_post_meta( $post_id, '_auto_video_code', true );
	$vendor = parse_url($auto_video_code);
	if ($vendor['host'] == 'www.youtube.com' || $vendor['host'] == 'youtu.be' || $vendor['host'] == 'www.youtu.be' || $vendor['host'] == 'youtube.com'){
		return 'http://img.youtube.com/vi'.esc_attr($vendor['path']).'/hqdefault.jpg';
	} elseif ($vendor['host'] == 'vimeo.com'){
		$imgid = esc_attr($vendor['path']);
		$hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video$imgid.php"));
		return $hash[0]['thumbnail_large'];
	} else {
		return '';
	}

}

function pixad_get_attach_video($post_id) {
	if(!$post_id) return false;
	$auto_video_code = get_post_meta( $post_id, '_auto_video_gallery', false );

	return $auto_video_code;
}

?>